package de.mse.uebung2.loesung2;

import java.util.ArrayList;
import java.util.HashSet;

public class Polyeder {

   int polyId;
   ArrayList<Flaeche> huelle;

   public Polyeder(int polyId, ArrayList<Flaeche> huelle) {
      this.polyId = polyId;
      this.huelle = huelle;
   }

   public void skalieren(float faktor) {
      HashSet<Punkt> punkte = findePunkte();
      for (Punkt punkt : punkte) {
         punkt.skalieren(faktor);
      }
   }

   public void verschieben(float deltaX, float deltaY, float deltaZ) {
      HashSet<Punkt> punkte = findePunkte();
      for (Punkt punkt : punkte) {
         punkt.verschieben(deltaX, deltaY, deltaZ);
      }
   }

   public HashSet<Punkt> findePunkte() {
      HashSet<Punkt> ergebnis = new HashSet<Punkt>();
      for (Flaeche flaeche : huelle) {
         ergebnis.addAll(flaeche.findePunkte());
      }
      return ergebnis;
   }

   @Override
   public String toString() {
      String result = "Polyeder id = " + polyId + "\n";
      for (int i = 0; i < huelle.size(); i++) {
         result += huelle.get(i).toString();
      }
      return result;
   }
}
